; Example Script.nsi
; -------------------------------------------------
; 
; This script can easily me modified to make NSIS 
; installers for other JSGME mods for Wings Over 
; The Reich. Sections to modify are 
; highlighted between [=== Begin End ===] comments
; 
; -------------------------------------------------

; includes - don't touch!
!include "TextFunc.nsh"
!include "FileFunc.nsh"

; === Begin Cusomization ===

; configure installer
Name "Example WOTR Mod - No Drums"
OutFile "Example WOTR Mod NoDrums_1.0.exe"

; license info - text to show on main screen
LicenseText "Example WOTR Mod - No Drums during WOTR Startup"
LicenseData "Example WOTR MOD ReadMe File.rtf"	; .rtf or .txt file

; === End Cusomization ===

; configure compression - should get best ratio for most mods
SetCompressor /FINAL /SOLID lzma

; check registry for WOTR "WOTR" directory
InstallDirRegKey HKCU "Software\VB and VBA Program Settings\OTRManager5\Settings" "CFS3Path"

; request application privileges for UAC
; needed if WOTR in Program Files for Vista/Win7
RequestExecutionLevel admin

; set pages in installer
Page license
Page components
Page instfiles

; stuff to install
Section "Mod Installation (required)"
	SectionIn RO	; mark as required
	
	; set paths

	; WOTR root installation dir, parent of CFS3Path
	Var /GLOBAL WOTRDir
	${GetParent} $INSTDIR $WOTRDir

	; WOTR JSGME mod folder
	Var /GLOBAL ModDir
	IfFileExists "$WOTRDir\JSGME.ini" loadmod skipmod 
		skipmod:	; no valid OFF/JSGME install
			Abort "JSGME not found in $WOTRDir. Install that first!"
			Goto continue	; just here if we do something other than Abort
		loadmod:
			; read the mod folder from the ini file
			${ConfigRead} "$WOTRDir\JSGME.ini" "Name=" $R9
			StrCpy $ModDir "$WOTRDir\$R9\"

			; Set output path to the WOFF JSGME mod folder
			SetOutPath $ModDir 

			; change to root install directory
			StrCpy $OUTDIR $ModDir

	continue:

	; Install mod

; === Begin Cusomization ===

	; You can list as many files and mod folders as you want
	; these will all be installed in the JSGME mods folder
	; as configured by the user's JSGME.ini file.

	; documentation
	File "Example WOTR MOD ReadMe File.rtf"

	; mod folders themselves, recursively getting subfolders
	File /r "Example WOTR Mod - No Drums"

; === End Cusomization ===

	; path to parent JSGME folder
	StrCpy $OUTDIR $WOTRDir

; === Begin Cusomization ===

	; run JSGME - comment this line out with a semi-colon otherwise
	ExecShell "open" "JSGME.exe" ""

; === End Cusomization ===

SectionEnd
